clc,clear, close all

%% Tirando le somme dei test sul platooning
Lmemo=[]; Cmemo=[];

%%
LibO = myOutputFile;

disp('Files Analizzati')
elenco=strings(0,1);
elencoFiles = dir('C:\Users\nitro\Desktop\old tesi\I Miei Progressi/results Platoon/Loa');
for i=1:length(elencoFiles)
    if contains(elencoFiles(i).name,'TEST')
        elenco(end+1) = string([elencoFiles(i).folder filesep elencoFiles(i).name]);
        disp( elencoFiles(i).name)
    end
end
%%
for fileN=elenco

temporaneo = LibO.txt2struct(char(fileN),'results Platoon');
[D,t,~]=LibO.extractFromFile(temporaneo.loa);
tag = strsplit(temporaneo.loa,filesep);
a=plot(t,D(:,1),'-','LineW',0.25,'DisplayName',...
    regexprep(tag{end},'5winds.*',''),'tag','real'); hold on

[tgood, Lgood, Cgood] = deal(cell(1,5));

interv=0:60:60*4;
closer=7;
for i=1:length(interv)
intgood = [interv(i)+closer interv(i)+60-closer];
tgood{i} = intgood;
Lgood{i} = D(t>=intgood(1) & t<=intgood(2),1);
Cgood{i} = D(t>=intgood(1) & t<=intgood(2),4);
plot(intgood,mean(Lgood{i})*[1 1],'--','LineW',2,'Color',a.Color);
end
Lmemo(end+1,:) = cellfun(@mean,Lgood);
Cmemo(end+1,:) = cellfun(@mean,Cgood);
end

%%
set(gcf,'Color','w');
ll=legend(findobj(gca,'Tag','real')); ll.ItemHitFcn=@myTdmsReader.ShowOnOff;
xticks(0:60:300);
fermo = ylim
xlabel('Time [s]');  xlim([0 300])
ylabel('Load Cell [V]');
title({'Test Platooning per 5 velocità del vento'; char(strjoin('['+string(500:100:900)'+" giri]",',       '))})
%%
xticks(cat(2,tgood{:}));
ylim(fermo)
%% Variazione percentuale di E su E0
E0 = Lmemo(1,:); LsuD = [0.25 0.5 0.75 1 1.5 2 3];
wind = [500 600 700 800 900];
E = Lmemo(2:end,:);

zeroV = LibO.txt2struct('C:\Users\nitro\Desktop\old tesi\I Miei Progressi\results Daq\Loa\TaraZero_Loa (first).txt');
zeroV = LibO.extractFromFile(zeroV.loa);
zeroV = mean(zeroV(:,[1 4]));

[WindTab,CDTab,DragTab] = deal([]);
for i=1:size(Lmemo,1)
out = myTdmsReader.computeCd([Lmemo(i,:)' Cmemo(i,:)'],[],zeroV);
DragTab(end+1,:) =  out.Drag';
CDTab(end+1,:) = out.Cd';
WindTab(end+1,:) = out.Uinf';
end

figure
for i=1:size(E,1) %scorro gli L/d 
subplot(2,1,1)
plot(wind, (-E(i,:)+E0)./E0*100,'-p','DisplayN',"L/D = "+LsuD(i)), hold on

subplot(2,1,2)
CD0 = CDTab(1,:);
plot(wind,CDTab(i+1,:),'-p','DisplayN',"C_{D_{L/D = "+LsuD(i)+"}}"), hold on
end
plot(wind,CDTab(1,:),'-pk','DisplayN',"C_{D.no platooning}");

subplot(2,1,1)
xlabel('Wind [n]'), ylabel('\DeltaE%')
legend

subplot(2,1,2)
xlabel('Wind [n]'), ylabel('C_D')
legend
set(gcf,'Color','w')

%%
figure
for i=1:size(CDTab,2) 
subplot(2,1,1)
 
dE(:,i) =  (-Lmemo(2:end,i)+E0(i))/E0(i)*100;
plot(LsuD,dE(:,i),'-p','DisplayN',"\DeltaE%_{n = "+wind(i)+"}");
hold on

subplot(2,1,2)
tipo = 'CD';
switch tipo
    case 'CDrel'
dCD = (CDTab(2:end,i)-CDTab(1,i))/CDTab(1,i)*100;
plot([LsuD(1)-0.1 nan LsuD],[0; nan; dCD],'-p','DisplayN',"\Delta%C_{D_{n = "+wind(i)+"}}");
ylabel('\DeltaC_D%'), text(LsuD(1)-0.05,0,'\leftarrow\Delta%C_{D_{no platooning}}');
ylim([-60 5])
    case 'CD'
plot([LsuD(1)-0.1 nan LsuD],[CDTab(1,i); nan; CDTab(2:end,i)],'-p','DisplayN',"C_{D_{n = "+wind(i)+"}}");
ylabel('C_D'), ylim([0 0.6])
    if i==1
    text(LsuD(1)-0.05,CDTab(1,i),'\leftarrowC_{D_{no platooning}}');
    end
end
hold on
end
set(gcf,'Color','w')

subplot(2,1,1)
xlabel('L/D'), ylabel('\DeltaE%')
xlim([0 3.2])
legend

subplot(2,1,2)
xlabel('L/D'), 
xlim([0 3.2])

legend

